/**
* \file: configuration.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: authorization level daemon
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef ALD_CONTROL_CONFIGURATION_H
#define ALD_CONTROL_CONFIGURATION_H

#include <stdbool.h>
#include <stdint.h>
#include <bits/types.h>

#include "util/logger.h"


error_code_t configuration_init(int argc, char *argv[]);

void configuration_deinit(void);

error_code_t configuration_parse_ald_configuration_file(void);

const char *configuration_get_proc_name(void);

logger_loglevel_t configuration_get_loglevel(void);

bool configuration_is_console_enabled(void);

const char *configuration_get_persisted_state_path(void);

const char *configuration_get_script_root_dir(void);

const char *configuration_get_signature_db_path(void);

const char *configuration_get_signature_db_pub_key_path(void);

uint32_t configuration_get_challenge_timeout_ms(void);

uint32_t configuration_get_script_exec_timeout_ms(void);

const char *configuration_get_replay_level_trigger_path(void);

const char *configuration_get_level_change_complete_file_path(void);

uint32_t configuration_get_challenge_verify_key_behaviour(void);

#endif
